unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ImgList, Grids;

type
  TMainForm = class(TForm)
    dg: TDrawGrid;
    ImageList1: TImageList;
    Panel1: TPanel;
    imgKONIEC: TImage;
    le: TLabeledEdit;
    procedure dgSelectCell(Sender: TObject; ACol, ARow: Integer;
      var CanSelect: Boolean);
    procedure dgDrawCell(Sender: TObject; ACol, ARow: Integer; Rect: TRect;
      State: TGridDrawState);
    procedure FormCreate(Sender: TObject);
    procedure imgKONIECClick(Sender: TObject);
  private

  public
    procedure Koniec();
  end;

var
  MainForm: TMainForm;

implementation
{$R *.dfm}
{------------------------------------------------------------------------------}
procedure TMainForm.dgDrawCell(Sender: TObject; ACol, ARow: Integer; Rect: TRect; State: TGridDrawState);
var
	lp : Integer;

begin
   lp := ARow * dg.ColCount + ACol;

   ImageList1.Draw(dg.Canvas, Rect.left, Rect.top, lp);
	(*
	TDrawingStyle = (dsFocus, dsSelected, dsNormal, dsTransparent);
	*)
end;

procedure TMainForm.dgSelectCell(Sender: TObject; ACol, ARow: Integer; var CanSelect: Boolean);
begin
	le.Text := IntToStr(ACol);
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
	dg.Align    := alClient;
	dg.ColCount := 6;
end;

procedure TMainForm.imgKONIECClick(Sender: TObject);
begin
	Koniec();
end;

procedure TMainForm.Koniec();
begin
	if Application.MessageBox('Koniec pracy', 'Uwaga', MB_ICONINFORMATION or MB_YESNO) = mrYes then
	begin
		Close();
   end;
end;

end.
